<!-- Parent: Arenduse juhendid ja nõuded -->
<!-- Label: requirements -->
<!-- Label: architecture -->
<!-- Label: standards -->

# Tehnilised nõuded tarkvaralahendustele

!!! info
    Arhitektuuriliste otsuste, infrastruktuuri seadistamise ja äriprotsesside standardid ettevõtte tarkvaralahenduste jaoks SMIT majutusplatvormil. Suunatud arhitektidele, projektijuhteile ja administraatoritele.

    Need nõuded määratlevad millele peaksid loodavad tarkvara komponendid vastama, et nad ei oleks infrastruktuurist jäigalt sõltuvates, töötaksid SMIT majutusplatvormil, nende skaleerimist ja paigaldamist saaks automatiseerida ning tehnoloogiline võlg oleks hallatav ja mõõdetav.

    Need nõuded vajavad inimeste järelevalvet, protsessijuhtimist või infrastruktuuri konfigureerimist ja ei ole automaatselt jõustatavad arendusprotsessis.

    **Täiendav dokument**: Automaatselt AI abil jõustatavate tehniliste standardite jaoks vaata:

    - **SMIT Development Standards repositoorium**: [https://source.smit.sise/projects/IDP/repos/smit-development-standards/browse](https://source.smit.sise/projects/IDP/repos/smit-development-standards/browse)
    - **AI jõustatavad reeglid**: [rules/common/component-technical-standards.mdc](https://source.smit.sise/projects/IDP/repos/smit-development-standards/browse/rules/common/component-technical-standards.mdc) (42 reeglit)
    - **Raamistiku-spetsiifilised reeglid**: `rules/java-spring-boot/`, `rules/typescript-vue/`, `rules/typescript-angular/` jt

See repositoorium sisaldab AI assistendi konfiguratsiooni, kodeerimise standardeid ja arendusreegleid, mis on automaatselt jõustatavad Cursor IDE ja teiste AI assistentide poolt.

## Arhitektuurinõuded ja infrastruktuuriotsused

### 1. Üldine

| Nr | Nõue | Kohustuslik | Märkused ja lingid |
|----|------|-------------|-------------------|
| 1.1 | Rakendused luuakse "bounded context" põhimõttel - ühte komponenti ei panda sisult erinevat funktsionaalsust | **<span style="color: red;">KOHUSTUS</span>** | Komponentideks jaotamine toimub sisulistest, mitte tehnilistest funktsionaalsustest lähtudes v.a kasutajaliideste eraldamine. Vältida hajust monoliiti. Vt: [Microservices](http://martinfowler.com/articles/microservices.html), [Bounded Context](https://martinfowler.com/bliki/BoundedContext.html), [Microservices Pitfalls](https://microservices.io/microservices/general/2018/11/04/potholes-in-road-from-monolithic-hell.html) |
| 1.2 | Komponent peab jooksma vähemalt 2 instantsi peal platvormi katkestuste vältimiseks | **<span style="color: red;">KOHUSTUS</span>** | Konteinerplatvormile paigaldatud rakenduste puhul minimaalselt 2 instantsi toodangus. Eelistada komponentide hulga tõstmist, mitte ressursikasutuse tõstmist |
| 1.3 | Ehitamine SMIT CI/CD-ga (Bamboo), staatilise koodi analüüs SonarQube-ga | **<span style="color: red;">KOHUSTUS</span>** | Lähtekood ei tohi sisaldada analüsaatori poolt leitud vigu. Minimaalne vaikeprofiil. Vt: "Tehnoloogilise võla mõõtmine (SonarQube)" dok |
| 1.4 | Rakenduse lähtekood kirjutatud selgusega, mis võimaldab erialast ettevalmistust omaval tarkvaraarendajal süsteemi edasi arendada | **<span style="color: red;">KOHUSTUS</span>** | Rakenduse lähtekood ja kommentaarid peavad olema inglise keeles. Rakenduse ärilised muutujad aga eesti keeles, kui neile pole mõlemapoolset loogilist vastet |
| 1.5 | Rakenduse lähtekoodi haldus toimib SMIT kesksete versioonihalduspõhimõtete järgi | **<span style="color: red;">KOHUSTUS</span>** | Kehtib nii loogika kui kasutajaliidese komponendi puhul. Lisainfo leiab dokumendist: "Lähtekoodi halduse ja ehitamise nõuded" |
| 1.6 | Keskkondadesse rakenduste paigaldamine on automatiseeritud SMIT CI/CD mehhanismidega | **<span style="color: red;">KOHUSTUS</span>** | Kasutatakse Bamboo paigaldusplaane: [Bamboo Deployment Projects](https://confluence.atlassian.com/bamboo/deployment-projects-338363438.html) |
| 1.7 | Rakendustel puudub ligipääs avalikku internetti (sh klientidel) | **<span style="color: red;">KOHUSTUS</span>** | Kui on vajalik ligipääs äriandmetele väljaspool SMIT võrku, tuleb tellida "webproxy" ligipääs |
| 1.8 | Kõik välised sõltuvused tuleb rakenduse ehitamisprotsessi käigus läbi skaneerida Artifactory Xray töövahendiga | **<span style="color: red;">KOHUSTUS</span>** | Mitte kasutada kõrge kriitilisusega turvanõrkuseid sisaldavaid teeke/komponente. [JFrog CLI for Xray](https://jfrog.com/help/r/jfrog-cli/cli-for-jfrog-xray) |
| 1.9 | Rakenduse arhitektuuri koostamisel tuleks arvestada, et komponente peab saama uuendada iseseisvalt | Soovituslik | Soovituslik kasutada "Blue-Green" paigalduspõhimõtteid |
| 1.10 | Rakendustevahelisi integratsioone teostatakse kokkulepitud põhimõtete järgi | **<span style="color: red;">KOHUSTUS</span>** | Võimalikud variandid: XTEE, HTTP otse või MQ. Integratsioonide disainis lähtuda dokumendist: "Rakendustevahelised integratsioonipõhimõtted" |
| 1.11 | API spetsifikatsioonid peavad olema kättesaadavad kolmandatele osapooltele | **<span style="color: red;">KOHUSTUS</span>** | OpenAPI/Swagger spetsifikatsioon peab olema eraldi ligipääsetav välispartneritele integratsioonide jaoks. Versiooninumber võib olla kas päises või URI-s. Teenuse tehnilises dokumentatsioonis peab olema viide OpenAPI spetsifikatsionile (SwaggerUI). API disainimisel tuleb lähtuda dokumendist: "Rakendustevahelised integratsioonipõhimõtted" |
| 1.12 | Kui loodav lahendus koosneb mitmest komponendist, on need lahus arendatavad, pakendatavad, versioneeritavad ja paigaldatavad | **<span style="color: red;">KOHUSTUS</span>** | Võimaldab erinevate komponentide iseseisvat arendamist ja paigaldamist |
| 1.13 | Rakendused automaatselt monitooritud toodangus | **<span style="color: red;">KOHUSTUS</span>** | Toodangu keskkondades on automaatne monitooring kohustuslik |
| 1.14 | Kasuta SMIT raamistike põhjasid uute komponentide jaoks | **<span style="color: red;">KOHUSTUS</span>** | Erandid nõuavad arhitektuurinõukogu heakskiitu. Kasuta [SMIT Examples](https://source.smit.sise/projects/EXAMPLES) starterkit malle. Kui sobilikku põhja ei eksisteeri, tuleb selle minimaalne versioon projekti käigus tekitada |
| 1.15 | Rakendus on versioneeritud kasutades "semantic versioning" põhimõtet | **<span style="color: red;">KOHUSTUS</span>** | A.B.C kujul, kus C on veaparandus, B on funktsionaalne uuendus mis töötab vanematel integratsioonidel ja A on integratsioone potentsiaalselt lõhkuv uuendus. Versiooni suurt numbrit A kasutatakse ka API versiooni defineerimiseks. Vt: [Semantic Versioning](https://semver.org/). Soovitus: major versiooni uuendamisel tagastada vanema versiooniga teenused päises X-API-Deprecated |
| 1.16 | Ehitamise, reliisimise ja paigaldamise etapid on rangelt eraldatud | **<span style="color: red;">KOHUSTUS</span>** | Ehitamine toodab muutumatu artefakti, reliis laeb artifakti ülesse, paigaldamine kombineerib artifakti konfiguratisooniga ja käivitab keskonnas. Iga etapp peab olema iseseisev ja korratav. Vt: ["12-Factor Build Release Run"](https://12factor.net/build-release-run) |
| 1.17 | Komponendid peavad käivituma kiiresti ja sulguma korrektselt (graceful shutdown) | **<span style="color: red;">KOHUSTUS</span>** | Käivitusaeg maksimaalselt 60 sekundit, korrektne sulgumine SIGTERM signaali peale. Komponendid peavad olema "disposable" - saab igal hetkel peatada ja käivitada. Toetab kiiremat skaleerimist ja paigaldamist |
| 1.18 | Üks lähtekood repositoorium komponendi kohta - kõik keskkonnad paigaldatakse samast koodist | **<span style="color: red;">KOHUSTUS</span>** | Iga komponent peab omama ühte Git repositooriumit. Erinevad keskkonnad (arendus, test, toodang) kasutatavad sama lähtekoodi, kuid erinevat konfiguratsiooni. Git "branching" strateegia peab toetama sellist lähenemist |
| 1.19 | Kõik sõltuvused tuleb deklareerida spetsfiiliselt ja isoleerida | **<span style="color: red;">KOHUSTUS</span>** | Komponendid ei tohi sõltuda süsteemi-laadsetes teekidest. Kasutada "dependency manifest" faile ja lukustatud versioone reprodutseeritavate ehituste jaoks. Isoleerida sõltuvused konteinerite või virtuaalsete keskkondadega |
| 1.20 | Administratiivsed ülesanded käivitatakse eraldi protsessidena | **<span style="color: red;">KOHUSTUS</span>** | Andmebaasi migratsioonid, ühekordased skriptid ja muud administratiivsed toimingud peavad töötama eraldi komponent põhiprotsessidest. Admin ülesanded kasutavad sama koodi baasi, kuid käivitatakse eraldi |
| 1.21 | Komponendid peavad olema iseseisavad ja eksportima teenuseid pordi sidumise kaudu | **<span style="color: red;">KOHUSTUS</span>** | Komponendid ei tohi sõltuda välisest runtime serverist (Apache, Nginx). Iga komponent peab sisaldama oma HTTP serverit ja siduma end konfigureeritava pordi külge. Toetab mitme instantsi käivitamist samal masinal |

### 2. Testimine

| Nr | Nõue | Kohustuslik | Märkused ja lingid |
|----|------|-------------|-------------------|
| 2.1 | Minimaalne testandmete genereerimise võimekus | Soovituslik | Peamiselt koormustestide või "smoke" testide keskkondade jaoks |
| 2.2 | Test- ja toodangukeskkonnad eraldatud | **<span style="color: red;">KOHUSTUS</span>** | Testandmed ei tohi olla toodanguandmed (välja arvatud avalikud andmed nagu aadressid) |
| 2.3 | Kasutajaliidese automaattestide kirjutamine on arendusmeeskonna otsustada | Soovituslik | Testide loomisel on soovitav kasutada ilma kasutajaliideta sirvijat ("headless" brauserid) |
| 2.4 | Rakenduse automaattestide mahtu tuleb analüüsida CI/CD mehhanismidega ja publitseerida SMIT SonarQube keskkonnas | **<span style="color: red;">KOHUSTUS</span>** | Testide mahu miinimum määratakse SonarQube kvaliteediväravaga (reeglina 80% kogu koodist) |
| 2.5 | Testikattuvus peab olema vähemalt 80% kogu koodist | **<span style="color: red;">KOHUSTUS</span>** | Testikattuvuse miinimum jõustatakse SonarQube kvaliteediväravaga. Erandid või madalama läve kasutamine tuleb arhitektuurinõukogus kooskõlastada |
| 2.6 | Turvatestid avalike teenuste jaoks | **<span style="color: red;">KOHUSTUS</span>** | Turvatestide juhendid ja nõuded leiab dokumendist: "Turvatestimine" |
| 2.7 | Rakenduste poolt toodetavale logi väljundile tuleb kirjutada automaattestid | **<span style="color: red;">KOHUSTUS</span>** | Testid peavad veenduma, et rakenduses genereeritud logi vastab "Logimise nõuded" dokumendis kirjeldatud nõuetele |

### 3. Kasutajaliides

| Nr | Nõue | Kohustuslik | Märkused ja lingid |
|----|------|-------------|-------------------|
| 3.1 | Kasutajaliides võib korraga suhelda mitme loogikakomponendiga | Soovituslik | Võimaldab paindlikku arhitektuuri disaini |
| 3.2 | Kasutajaliides on soovitav arendada õhukese kliendina | Soovituslik | Thin client arhitektuuri eelistamine |
| 3.3 | Avalikud kasutajaliidesed peavad järgima VEERA disainistandardit ning omama WCAG tuge | Soovituslik | Vajadusel kohaldatav avalike teenuste puhul |

### 4. Infrastruktuur ja paigaldamine

| Nr | Nõue | Kohustuslik | Märkused ja lingid |
|----|------|-------------|-------------------|
| 4.1 | Rakendused peavad jooksma vähemalt 2 instantsi peal | **<span style="color: red;">KOHUSTUS</span>** | Platvormi muudatuste käigus katkestuste vältimine. Konteinerplatvormil minimaalselt 2 instantsi toodangus |
| 4.2 | Komponendid peavad olema iseseisvalt arendatavad, pakendatavad, versioneeritavad ja paigaldatavad | **<span style="color: red;">KOHUSTUS</span>** | Võimaldab sõltumatut arendust ja paigaldamist |
| 4.3 | Komponendid suhtlevad omavahel ainult üle HTTP/HTTPS või JMS/AMPQ protokolli | **<span style="color: red;">KOHUSTUS</span>** | Soovitus kasutada protokolle üle turvalise kanali (HTTPS/AMPQS) |
| 4.4 | Iga komponent peab omama oma andmebaasi, kui vajab andmete salvestamist | **<span style="color: red;">KOHUSTUS</span>** | Andmebaasidevahelised integratsioonid on keelatud. Mitu komponenti ei tohi kasutada sama andmebaasi |
| 4.5 | Kasutada eraldi failide hoidmise teenust binaarfailide jaoks | **<span style="color: red;">KOHUSTUS</span>** | SMIT-is on selleks olemas sisemine S3 objektihoidla |
| 4.6 | Toetada horisontaalset skaleerimist | **<span style="color: red;">KOHUSTUS</span>** | Suurendada instantside arvu, mitte ressursse instantsi kohta |
| 4.7 | Komponent käivitub ilma ühenduseta liidestetavate süsteemidega | **<span style="color: red;">KOHUSTUS</span>** | Nõrgalt liidestatud, välja arvatud andmebaasid |
| 4.8 | Komponent töötab osaliselt ka liidestuste katkestuste puhul | **<span style="color: red;">KOHUSTUS</span>** | Kasutada Circuit Breaker või retry mehhanisme. Healthcheck peab andma teada probleemist |
| 4.9 | Komponentide käivitusaeg peab olema alla 60 sekundi | **<span style="color: red;">KOHUSTUS</span>** | Kiire käivitamine skaleerimise ja taaskäivitamise jaoks |
| 4.10 | Kasutada SSL kõigile UI-backend suhtlustele | **<span style="color: red;">KOHUSTUS</span>** | SSL termineeritakse koormusjaoturis |
| 4.11 | Kasutada distribueeritud vahemälulahendusi | **<span style="color: red;">KOHUSTUS</span>** | Vältida vahemälu replikatsiooni, kasutada nt. Redis või andmebaasi |
| 4.12 | Konfiguratsioon keskkonna muutujatena või platvormi võimalustega | **<span style="color: red;">KOHUSTUS</span>** | Puudub eraldi väline konfiguratsioonifail. Kasutada Kubernetes secrets/configmap. Rakenduse saladused, mida ei genereerita teenuste poolt automaatselt, panna SMIT saladuste hoidlasse. Saladused liiguvad rakendusse ainult läbi CI/CD |
| 4.13 | Komponendi pakendamine Docker konteinerina SMIT baasimageidega | Soovituslik | Soovituslik pakendamisformaat on Docker konteiner. Kasutada ainult SMIT dockerhubis asuvaid baasimageid: [SMIT DockerHub](https://source.smit.sise/projects/dockerhub) |
| 4.14 | Failid tuleb skaneerida enne salvestamist | **<span style="color: red;">KOHUSTUS</span>** | Kasutada SMIT MetaVault teenust |

### 5. Sõltuvuste haldamine

| Nr | Nõue | Kohustuslik | Märkused ja lingid |
|----|------|-------------|-------------------|
| 5.1 | Kõik sõltuvused tuleb lahendada SMIT sisesest repositooriumist | **<span style="color: red;">KOHUSTUS</span>** | [SMIT Artifactory](https://artifacts.smit.sise). Ei tohi kasutada väliseid repositooriume (Maven Central, NPM, PyPI) otse |
| 5.2 | Konfigureerida ehitusvahendid kasutama SMIT repositooriumi | **<span style="color: red;">KOHUSTUS</span>** | Kõik välised sõltuvused peavad olema Artifactory kaudu kättesaadavad |

### 6. Äriloogika

| Nr | Nõue | Kohustuslik | Märkused ja lingid |
|----|------|-------------|-------------------|
| 6.1 | Komponentide vaheline andmevahetus peab olema turvaline TLS-iga, sertifikaate verifitseeritakse | Soovituslik | Autentimata ja/või krüpteerimata protokollide kasutamisel rakendatakse täiendavaid konfidentsiaalsust ja terviklust tagavaid turvameetmeid |
| 6.2 | Kasuta SMIT keskset tuvastamise teenust (UAA) | **<span style="color: red;">KOHUSTUS</span>** | UAA integreeritud RIA Taraga ID-kaart, mobiil-ID, Smart-ID jaoks. [UAA API Docs](https://docs.cloudfoundry.org/api/uaa/version/76.13.0/index.html#overview). Väliste kasutajate puhul kasuta e-posti põhist OTP-d |
| 6.3 | Kasutajate ja nende gruppide/rollipõhiste õiguste tuvastamine kesksest Active Directory-st | **<span style="color: red;">KOHUSTUS</span>** | Vähemalt üks AD roll peab asuma AD-s (ja vastav UAA skoop). AD gruppidest võetakse info ja lisatakse UAA tokeni skoopi. Andmetepõhised õigused (ACL) asuvad rakenduse andmebaasis |
| 6.4 | Iga komponent peab omama oma kontot | **<span style="color: red;">KOHUSTUS</span>** | Ei tohi taaskasutada kontosid, mis on väljastatud teistele rakendustele |
| 6.5 | Komponendid peavad saama omavahel autoriseerituna andmeid vahetada kasutades tokeneid | **<span style="color: red;">KOHUSTUS</span>** | Kahe komponendi vaheliseks andmevahetuseks, mis ei toimu lõppkasutaja kontekstis, tuleb kasutada SVC tüüpi süsteemikontosid ADs lisatud vajalike skoopidega |
| 6.6 | Tuvastatud kasutajal peab eksisteerima serveripoolne sessioon keskses hoidlas | **<span style="color: red;">KOHUSTUS</span>** | Kasutada ainult OAuth2 Authorization Code mehhanismi. Keskse seansi hoidlana Redis või PostgreSQL. Klient peab saama tokeniga seotud info kustutada. Mitmest komponendist koosneva rakenduse puhul kasutada API gateway sessioonihaldajana |
| 6.7 | Komponendi versiooniuuendused tehakse ilma katkestusteta teenuse töös | Soovituslik | Soovitav "Blue-Green deployment" mehhanism. [Blue-Green Deployment](https://martinfowler.com/bliki/BlueGreenDeployment.html). Andmebaasi muudatuste tegemisel tagada töötamine ka eelmiste versioonidega |
| 6.8 | Töövoogude koordineerimisel kasutada protsessimootorit | Soovituslik | Tagab protsesside parema läbipaistvuse ja modelleerimisvõimekuse. Näiteks [Camunda](https://camunda.com/) või [Flowable](https://flowable.org/) |
| 6.9 | Kasutada välist ACL süsteemi õiguste haldamiseks | Soovituslik | Keskne õiguste haldus ja auditeeritavus. Näiteks [Permify](https://permify.co/) või sarnased lahendused |

### 7. Andmebaas

| Nr | Nõue | Kohustuslik | Märkused ja lingid |
|----|------|-------------|-------------------|
| 7.1 | Eraldi operatiiv- ja arhiiv andmebaasid | **<span style="color: red;">KOHUSTUS</span>** | Kasuta eraldi arhiivandmebaase või spetsialiseeritud arhiveerimislahendusi |
| 7.2 | Andmebaaside vahelised integratsioonid ei ole lubatud | **<span style="color: red;">KOHUSTUS</span>** | Erinevad andmebaasid ei tohi omavahel integreeruda |
| 7.3 | Andmebaase komponentide integratsioonivahendina ei tohi kasutada | **<span style="color: red;">KOHUSTUS</span>** | Mitu erinevat komponenti ühe andmebaasi poole pöörduda ei ole lubatud. See ei tähenda, et sama komponenti skaleerides ei võiks kasutada sama andmebaasi |
| 7.4 | Migratsiooniskriptide käivitamine paigaldusprotsessi osana | **<span style="color: red;">KOHUSTUS</span>** | Migratsioone on soovitav käivitada paigaldusprotsessi ühe osana, mitte iga rakenduse restardiga. Kõige lihtsam variant on määrata CI/CD keskkonna muutujaga. Mõistlik on migratsiooni teha ühe instantsiga, siis vajadusel uuesti paigaldus mitme instantsiga |
| 7.5 | Andmebaasi äriloogikat vaikimisi ei kirjutata (protseduurid ja triggerid) | **<span style="color: red;">KOHUSTUS</span>** | Kõrvalekalded tuleb defineerida ja põhjendada konkreetse komponendi arhitektuuridokumendis |

### 8. Jõudlus

| Nr | Nõue | Kohustuslik | Märkused ja lingid |
|----|------|-------------|-------------------|
| 8.1 | Sisemised komponendid kasutavad asünkroonset suhtlust | Soovituslik | Blokeeruvate lõimede vältimine ja efektiivne protsessorituumade kasutamine. Erand: kasutaja transaktsioonisisene suhtlus. Vt: [12 Factor Concurrency](http://12factor.net/concurrency), [Reactive Manifesto](http://www.reactivemanifesto.org/) |
| 8.2 | Jõudluse kasvamisel horisontaalne skaleerimine (instantside hulga tõstmine) | **<span style="color: red;">KOHUSTUS</span>** | Ei tohiks kasutada "scale-up" lahendust, kui seda ei määra konkreetne toote pakkuja |
| 8.3 | Mitte-operatiivsed lugemispäringud suunata võimalusel andmebaasi replikatele | Soovituslik | Vähendab peaandmebaasi koormust ja parandab jõudlust. Rakendada read-only operatsioonide jaoks |

### 9. Monitooring ja jälgimine

| Nr | Nõue | Kohustuslik | Märkused ja lingid |
|----|------|-------------|-------------------|
| 9.1 | Komponentide monitooringu info kättesaadavus kokkulepitud formaadis ja protokolliga | **<span style="color: red;">KOHUSTUS</span>** | Soovitavalt REST formaadis. Koormusjaotur peab aru saama, kas suunata liiklus konkreetsele nodele. Näide: Spring Boot Actuator endpoint /health. [Spring Boot Health](https://docs.spring.io/spring-boot/api/rest/actuator/health.html) |
| 9.2 | Rakendused automaatselt monitooritud toodangus APM tarkvara agentidega | **<span style="color: red;">KOHUSTUS</span>** | Monitooringu seadistamine ja haldamine. Toetatud tehnoloogiad: [AppDynamics Supported Environments](https://docs.appdynamics.com/display/PRO45/App+Server+Agents+Supported+Environments) |

### 10. Failid

| Nr | Nõue | Kohustuslik | Märkused ja lingid |
|----|------|-------------|-------------------|
| 10.1 | Failide skaneerimine enne salvestamist andmebaasi või objektihoidlasse | **<span style="color: red;">KOHUSTUS</span>** | Kasutada tuleb SMIT-i poolt pakutavat MetaVault teenust |

### 11. Taaskasutus

| Nr | Nõue | Kohustuslik | Märkused ja lingid |
|----|------|-------------|-------------------|
| 11.1 | Kontrollida enne uue komponendi arendamist SMIT-is olemasolevaid lahendusi | **<span style="color: red;">KOHUSTUS</span>** | Eelistada olemasolevaid lahendusi teenusena või paigaldatava tootena |
| 11.2 | Olemasoleva teenuse koodi eraldamine eraldi projektiks vajab arhitektuuripaneeli heakskiitu | **<span style="color: red;">KOHUSTUS</span>** | Eelnev diskussioon olemasoleva tiimiga soovitatav |
| 11.3 | Teenuste puhul väljaspool konkreetset infosüsteemi luua iseseisev tehnilise liidestuse võimekus | Soovituslik | Nt Kubernetes Operator: [operatorframework.io](https://operatorframework.io) |

### 12. Arvutitöökoht

| Nr | Nõue | Kohustuslik | Märkused ja lingid |
|----|------|-------------|-------------------|
| 12.1 | Uued seadmed peavad olema Windows või iOS põhised | **<span style="color: red;">KOHUSTUS</span>** | Toetatud seadmetüübid organisatsiooni IT-poliitika kohaselt |
| 12.2 | Rakendus võimeline väikeste versioonide iseuuendamiseks | **<span style="color: red;">KOHUSTUS</span>** | Võimaldab automaatseid väiksemaid uuendusi ilma IT-toe sekkumiseta |
| 12.3 | Paigaldus ei tohi keelata arvuti teenuseid | **<span style="color: red;">KOHUSTUS</span>** | Näide: DocCheck keelas ID kaardi sertifikaaditeenuse |
| 12.4 | Toetada kõiki heakskiidetud brausereid, mitte seotud konkreetse versiooniga | **<span style="color: red;">KOHUSTUS</span>** | Kõik brauserid tehnoloogiavaliku lehelt peavad olema toetatud |
| 12.5 | Tarkvara ja konfiguratsiooni tarne ATKH-le töökoha paigaldamiseks | **<span style="color: red;">KOHUSTUS</span>** | Arendus peab andma tarkvara + konfiguratsiooni ATKH-le |
| 12.6 | Domeeni valideerimine standard/erilises ATK profiilis | **<span style="color: red;">KOHUSTUS</span>** | Domeen peab valideeruma standard ATK profiilis või SMIT erilises profiilis |
| 12.7 | Rakendus peab olema käsurealt paigaldatav | **<span style="color: red;">KOHUSTUS</span>** | Võimaldab automatiseeritud paigaldamist ja masshaldust |
| 12.8 | Rakendus ei tohi nõuda administraatoriõigusi kasutamiseks | **<span style="color: red;">KOHUSTUS</span>** | Tavakasutaja peab saama rakendust kasutada ilma kõrgendatud õigusteta |
| 12.9 | Veebirakendused peavad toetama Chrome'i ja Firefoxi sisevõrgus | **<span style="color: red;">KOHUSTUS</span>** | Minimaalne brauserite tugi organisatsiooni sisevõrgus |

## Kategooriate kokkuvõte

| Sektsioon | Numbreid | Arv | Kohustuslikud | Valikulised |
|-----------|----------|-----|---------------|-------------|
| **1. Üldine** | 1.1-1.21 | 21 | 19 | 2 |
| **2. Testimine** | 2.1-2.7 | 7 | 6 | 1 |
| **3. Kasutajaliides** | 3.1-3.3 | 3 | 0 | 3 |
| **4. Infrastruktuur ja paigaldamine** | 4.1-4.14 | 14 | 13 | 1 |
| **5. Sõltuvuste haldamine** | 5.1-5.2 | 2 | 2 | 0 |
| **6. Äriloogika** | 6.1-6.9 | 9 | 7 | 2 |
| **7. Andmebaas** | 7.1-7.5 | 5 | 5 | 0 |
| **8. Jõudlus** | 8.1-8.3 | 3 | 1 | 2 |
| **9. Monitooring ja jälgimine** | 9.1-9.2 | 2 | 2 | 0 |
| **10. Failid** | 10.1 | 1 | 1 | 0 |
| **11. Taaskasutus** | 11.1-11.3 | 3 | 2 | 1 |
| **12. Arvutitöökoht** | 12.1-12.9 | 9 | 9 | 0 |
| **Kokku** | - | **79** | **66** | **13** |

## Märkused

- **<span style="color: red;">KOHUSTUS</span>** = Kohustuslik nõue
- **Soovituslik** = Soovitatud/valikuline nõue
- Kaks nõuet (1.9 ja 1.16) olid algselt märgitud välistatuks, kuid tegelikult lisati need AI reeglitesse täiendava analüüsi käigus
- Infrastruktuurinõuded vajavad platvormi/keskkonna seadistamist
- Protsessinõuded vajavad inimeste järelevalvet ja organisatsioonilist vastavust
- Arhitektuurinõuded vajavad inimeste disainiotsuseid
- Testimisnõuded vajavad inimeste testimisstrateegiat ja täitmist

---

> **📝 Git-managed page:** This content is automatically synced from [IDP Documentation Repository](https://source.smit.sise/projects/IDP/repos/idp-docs/browse/02-development-guidelines/technical-requirements.md). **Do not edit manually in Confluence** - all changes should be made in Git and will be automatically deployed.
